﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Xsl;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_CourseMenu : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {

            }

            public int id { get; set; }
            public long unit_id { get; set; }
            public string text { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_CourseMenu(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
                
        }

        public void Load()
        {
            switch (ContextParam.AuxyliaryPages)
            {
                case BL.Dictionary.AuxyliaryPagesType.CourseMenu: CourseMenu(ContextParam); break;
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
        }

        private void CourseMenu(BL.ZSBELearning.ContextParam ContextParam)
        {
            int _stubIndex = 0;

            foreach (BO.View.Unit _loopUnit in ContextParam.Units)
            {
                _stubIndex++;


                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.unit_id = _loopUnit.ID.Value;
                _loopStub.text = _loopUnit.Title;

                ExerciseData.Add(_loopStub);
            }
        }
    }
}
